sievebound_price<-function(theta){
  
  beta<-theta[1:(degree+1)]
  w1<-theta[degree+2]
  w2<-theta[degree+3]
  U<-exp(r*t)*beta%*%t(R1)        #C^u and P^u
  L<-pmax(exp(r*t)*beta%*%t(R2),beta%*%t(R1))  #C^l and P^l
  
  price<-rep(0,n)
  for (i in 1:n){
    if ( exp(r*t)*beta%*%(R2[i,])>0){
      price[i]<-w1*U[i]+(1-w1)*L[i]
    }else if ( exp(r*t)*beta%*%(R2[i,])<0){
      price[i]<-w2*U[i]+(1-w2)*L[i]
    }
  }
  
  
  return(price)
  
}

sievebound_mse<-function(theta){
  price<-sievebound_price(theta)
  mse<-sum((price-rbind(AO_C,AO_P))^2)
  return(mse)
}





